/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.command.impl.client;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2164;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.command.api.client.ClientCommandManager;
import org.quiltmc.qsl.command.api.client.ClientCommandRegistrationCallback;
import org.quiltmc.qsl.command.api.client.QuiltClientCommandSource;
import org.quiltmc.qsl.command.mixin.HelpCommandAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public final class ClientCommandInternals {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCommandInternals.class);
    private static final char PREFIX = '/';
    private static final String API_COMMAND_NAME = "quilt_commands:client_commands";
    private static final String SHORT_API_COMMAND_NAME = "qcc";
    private static final Command<QuiltClientCommandSource> DUMMY_COMMAND = ctx -> 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCommand(String message) {
        if (message.isEmpty()) {
            return false;
        }
        if (message.charAt(0) != '/') {
            return false;
        }
        class_310 client = class_310.method_1551();
        QuiltClientCommandSource commandSource = (QuiltClientCommandSource)client.method_1562().method_2875();
        client.method_16011().method_15396(message);
        try {
            String command = message.substring(1);
            CommandDispatcher serverDispatcher = client.method_1562().method_2886();
            ParseResults serverResults = serverDispatcher.parse(command, (Object)client.method_1562().method_2875());
            if (serverResults.getReader().canRead() || ClientCommandInternals.isCommandInvalidOrDummy(serverResults)) {
                ClientCommandManager.DISPATCHER.execute(command, (Object)commandSource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (CommandSyntaxException e) {
            boolean ignored = ClientCommandInternals.shouldIgnore(e.getType());
            if (ignored) {
                LOGGER.debug("Syntax exception for client-side command '{}'", (Object)message, (Object)e);
            } else {
                LOGGER.warn("Syntax exception for client-side command '{}'", (Object)message, (Object)e);
            }
            if (ignored) {
                boolean bl = false;
                return bl;
            }
            commandSource.sendError(ClientCommandInternals.getErrorMessage(e));
            boolean bl = true;
            return bl;
        }
        catch (class_2164 e) {
            LOGGER.warn("Error while executing client-side command '{}'", (Object)message, (Object)e);
            commandSource.sendError(e.method_9199());
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error while executing client-side command '{}'", (Object)message, (Object)e);
            commandSource.sendError(class_2561.method_30163((String)e.getMessage()));
            boolean bl = true;
            return bl;
        }
        finally {
            client.method_16011().method_15407();
        }
    }

    public static <S extends class_2172> boolean isCommandInvalidOrDummy(ParseResults<S> parse) {
        if (parse.getReader().canRead()) {
            return true;
        }
        String command = parse.getReader().getString();
        CommandContext context = parse.getContext().build(command);
        return context.getCommand() == null || context.getCommand() == DUMMY_COMMAND;
    }

    private static boolean shouldIgnore(CommandExceptionType type) {
        BuiltInExceptionProvider builtins = CommandSyntaxException.BUILT_IN_EXCEPTIONS;
        return type == builtins.dispatcherUnknownCommand() || type == builtins.dispatcherParseException();
    }

    private static class_2561 getErrorMessage(CommandSyntaxException e) {
        class_2561 message = class_2564.method_10883((Message)e.getRawMessage());
        String context = e.getContext();
        return context != null ? new class_2588("command.context.parse_error", new Object[]{message, context}) : message;
    }

    public static void initialize() {
        ((ClientCommandRegistrationCallback)ClientCommandRegistrationCallback.EVENT.invoker()).registerCommands(ClientCommandManager.DISPATCHER);
        if (!ClientCommandManager.DISPATCHER.getRoot().getChildren().isEmpty()) {
            LiteralCommandNode mainNode = ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal(API_COMMAND_NAME).then(ClientCommandInternals.createHelpCommand())).then(ClientCommandInternals.createRunCommand()));
            ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal(SHORT_API_COMMAND_NAME).redirect((CommandNode)mainNode));
        }
        ClientCommandManager.DISPATCHER.findAmbiguities((parent, child, sibling, inputs) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{ClientCommandManager.DISPATCHER.getPath(child), ClientCommandManager.DISPATCHER.getPath(sibling), inputs}));
    }

    private static LiteralArgumentBuilder<QuiltClientCommandSource> createRunCommand() {
        LiteralArgumentBuilder<QuiltClientCommandSource> runCommand = ClientCommandManager.literal("run");
        for (CommandNode node : ClientCommandManager.DISPATCHER.getRoot().getChildren()) {
            runCommand.then(node);
        }
        return runCommand;
    }

    private static LiteralArgumentBuilder<QuiltClientCommandSource> createHelpCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal("help").then(ClientCommandManager.argument("command", StringArgumentType.greedyString()).executes(ClientCommandInternals::executeSpecificHelp))).executes(ClientCommandInternals::executeRootHelp);
    }

    private static int executeRootHelp(CommandContext<QuiltClientCommandSource> context) {
        return ClientCommandInternals.executeHelp((CommandNode<QuiltClientCommandSource>)ClientCommandManager.DISPATCHER.getRoot(), context);
    }

    private static int executeSpecificHelp(CommandContext<QuiltClientCommandSource> context) throws CommandSyntaxException {
        ParseResults parseResults = ClientCommandManager.DISPATCHER.parse(StringArgumentType.getString(context, (String)"command"), (Object)((QuiltClientCommandSource)context.getSource()));
        List nodes = parseResults.getContext().getNodes();
        if (nodes.isEmpty()) {
            throw HelpCommandAccessor.getFailedException().create();
        }
        return ClientCommandInternals.executeHelp((CommandNode<QuiltClientCommandSource>)Objects.requireNonNull((ParsedCommandNode)Iterables.getLast((Iterable)nodes)).getNode(), context);
    }

    private static int executeHelp(CommandNode<QuiltClientCommandSource> startNode, CommandContext<QuiltClientCommandSource> context) {
        Map commands = ClientCommandManager.DISPATCHER.getSmartUsage(startNode, (Object)((QuiltClientCommandSource)context.getSource()));
        for (String command : commands.values()) {
            ((QuiltClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("/" + command));
        }
        return commands.size();
    }

    public static void addDummyCommands(CommandDispatcher<QuiltClientCommandSource> target, QuiltClientCommandSource source) {
        Object2ObjectOpenHashMap originalToCopy = new Object2ObjectOpenHashMap();
        originalToCopy.put((Object)ClientCommandManager.DISPATCHER.getRoot(), (Object)target.getRoot());
        ClientCommandInternals.copyChildren((CommandNode<QuiltClientCommandSource>)ClientCommandManager.DISPATCHER.getRoot(), (CommandNode<QuiltClientCommandSource>)target.getRoot(), source, (Map<CommandNode<QuiltClientCommandSource>, CommandNode<QuiltClientCommandSource>>)originalToCopy);
    }

    private static void copyChildren(CommandNode<QuiltClientCommandSource> origin, CommandNode<QuiltClientCommandSource> target, QuiltClientCommandSource source, Map<CommandNode<QuiltClientCommandSource>, CommandNode<QuiltClientCommandSource>> originalToCopy) {
        for (CommandNode child : origin.getChildren()) {
            if (!child.canUse((Object)source) || target.getChild(child.getName()) != null) continue;
            ArgumentBuilder builder = child.createBuilder();
            builder.requires(s -> true);
            if (builder.getCommand() != null) {
                builder.executes(DUMMY_COMMAND);
            }
            if (builder.getRedirect() != null) {
                builder.redirect(originalToCopy.get(builder.getRedirect()));
            }
            CommandNode result = builder.build();
            originalToCopy.put((CommandNode<QuiltClientCommandSource>)child, (CommandNode<QuiltClientCommandSource>)result);
            target.addChild(result);
            if (child.getChildren().isEmpty()) continue;
            ClientCommandInternals.copyChildren((CommandNode<QuiltClientCommandSource>)child, (CommandNode<QuiltClientCommandSource>)result, source, originalToCopy);
        }
    }
}

